@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.SecurityContactArgs.builder
import com.pulumi.azurenative.security.kotlin.inputs.SecurityContactPropertiesAlertNotificationsArgs
import com.pulumi.azurenative.security.kotlin.inputs.SecurityContactPropertiesAlertNotificationsArgsBuilder
import com.pulumi.azurenative.security.kotlin.inputs.SecurityContactPropertiesNotificationsByRoleArgs
import com.pulumi.azurenative.security.kotlin.inputs.SecurityContactPropertiesNotificationsByRoleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contact details and configurations for notifications coming from Microsoft Defender for Cloud.
 * Azure REST API version: 2020-01-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2017-08-01-preview, 2023-12-01-preview.
 * ## Example Usage
 * ### Create security contact data
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var securityContact = new AzureNative.Security.SecurityContact("securityContact", new()
 *     {
 *         AlertNotifications = new AzureNative.Security.Inputs.SecurityContactPropertiesAlertNotificationsArgs
 *         {
 *             MinimalSeverity = AzureNative.Security.MinimalSeverity.Low,
 *             State = AzureNative.Security.State.On,
 *         },
 *         Emails = "john@contoso.com;jane@contoso.com",
 *         NotificationsByRole = new AzureNative.Security.Inputs.SecurityContactPropertiesNotificationsByRoleArgs
 *         {
 *             Roles = new[]
 *             {
 *                 AzureNative.Security.Roles.Owner,
 *             },
 *             State = AzureNative.Security.State.On,
 *         },
 *         Phone = "(214)275-4038",
 *         SecurityContactName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSecurityContact(ctx, "securityContact", &security.SecurityContactArgs{
 * 			AlertNotifications: &security.SecurityContactPropertiesAlertNotificationsArgs{
 * 				MinimalSeverity: pulumi.String(security.MinimalSeverityLow),
 * 				State:           pulumi.String(security.StateOn),
 * 			},
 * 			Emails: pulumi.String("john@contoso.com;jane@contoso.com"),
 * 			NotificationsByRole: &security.SecurityContactPropertiesNotificationsByRoleArgs{
 * 				Roles: pulumi.StringArray{
 * 					pulumi.String(security.RolesOwner),
 * 				},
 * 				State: pulumi.String(security.StateOn),
 * 			},
 * 			Phone:               pulumi.String("(214)275-4038"),
 * 			SecurityContactName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SecurityContact;
 * import com.pulumi.azurenative.security.SecurityContactArgs;
 * import com.pulumi.azurenative.security.inputs.SecurityContactPropertiesAlertNotificationsArgs;
 * import com.pulumi.azurenative.security.inputs.SecurityContactPropertiesNotificationsByRoleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var securityContact = new SecurityContact("securityContact", SecurityContactArgs.builder()
 *             .alertNotifications(SecurityContactPropertiesAlertNotificationsArgs.builder()
 *                 .minimalSeverity("Low")
 *                 .state("On")
 *                 .build())
 *             .emails("john@contoso.com;jane@contoso.com")
 *             .notificationsByRole(SecurityContactPropertiesNotificationsByRoleArgs.builder()
 *                 .roles("Owner")
 *                 .state("On")
 *                 .build())
 *             .phone("(214)275-4038")
 *             .securityContactName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SecurityContact default /subscriptions/{subscriptionId}/providers/Microsoft.Security/securityContacts/{securityContactName}
 * ```
 * @property alertNotifications Defines whether to send email notifications about new security alerts
 * @property emails List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in this security contact.
 * @property notificationsByRole Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
 * @property phone The security contact's phone number
 * @property securityContactName Name of the security contact object
 */
public data class SecurityContactArgs(
    public val alertNotifications: Output<SecurityContactPropertiesAlertNotificationsArgs>? = null,
    public val emails: Output<String>? = null,
    public val notificationsByRole: Output<SecurityContactPropertiesNotificationsByRoleArgs>? = null,
    public val phone: Output<String>? = null,
    public val securityContactName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.SecurityContactArgs> {
    override fun toJava(): com.pulumi.azurenative.security.SecurityContactArgs =
        com.pulumi.azurenative.security.SecurityContactArgs.builder()
            .alertNotifications(
                alertNotifications?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .emails(emails?.applyValue({ args0 -> args0 }))
            .notificationsByRole(
                notificationsByRole?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .phone(phone?.applyValue({ args0 -> args0 }))
            .securityContactName(securityContactName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecurityContactArgs].
 */
@PulumiTagMarker
public class SecurityContactArgsBuilder internal constructor() {
    private var alertNotifications: Output<SecurityContactPropertiesAlertNotificationsArgs>? = null

    private var emails: Output<String>? = null

    private var notificationsByRole: Output<SecurityContactPropertiesNotificationsByRoleArgs>? = null

    private var phone: Output<String>? = null

    private var securityContactName: Output<String>? = null

    /**
     * @param value Defines whether to send email notifications about new security alerts
     */
    @JvmName("iywveenxjabprlcp")
    public suspend
    fun alertNotifications(`value`: Output<SecurityContactPropertiesAlertNotificationsArgs>) {
        this.alertNotifications = value
    }

    /**
     * @param value List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in this security contact.
     */
    @JvmName("hkxxlajvmamhofjf")
    public suspend fun emails(`value`: Output<String>) {
        this.emails = value
    }

    /**
     * @param value Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
     */
    @JvmName("ryvsnloljsvdujsy")
    public suspend
    fun notificationsByRole(`value`: Output<SecurityContactPropertiesNotificationsByRoleArgs>) {
        this.notificationsByRole = value
    }

    /**
     * @param value The security contact's phone number
     */
    @JvmName("auqcqagqbhwujnhw")
    public suspend fun phone(`value`: Output<String>) {
        this.phone = value
    }

    /**
     * @param value Name of the security contact object
     */
    @JvmName("yxmpnfftkbopacbm")
    public suspend fun securityContactName(`value`: Output<String>) {
        this.securityContactName = value
    }

    /**
     * @param value Defines whether to send email notifications about new security alerts
     */
    @JvmName("utbgihiiuknxfhin")
    public suspend fun alertNotifications(`value`: SecurityContactPropertiesAlertNotificationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertNotifications = mapped
    }

    /**
     * @param argument Defines whether to send email notifications about new security alerts
     */
    @JvmName("pabogfrpvwpbsxow")
    public suspend
    fun alertNotifications(argument: suspend SecurityContactPropertiesAlertNotificationsArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityContactPropertiesAlertNotificationsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.alertNotifications = mapped
    }

    /**
     * @param value List of email addresses which will get notifications from Microsoft Defender for Cloud by the configurations defined in this security contact.
     */
    @JvmName("fdowwqtwuufmybal")
    public suspend fun emails(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emails = mapped
    }

    /**
     * @param value Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
     */
    @JvmName("yxnahxtqcdtachxi")
    public suspend
    fun notificationsByRole(`value`: SecurityContactPropertiesNotificationsByRoleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationsByRole = mapped
    }

    /**
     * @param argument Defines whether to send email notifications from Microsoft Defender for Cloud to persons with specific RBAC roles on the subscription.
     */
    @JvmName("ohgscdaxcmlkomri")
    public suspend
    fun notificationsByRole(argument: suspend SecurityContactPropertiesNotificationsByRoleArgsBuilder.() -> Unit) {
        val toBeMapped = SecurityContactPropertiesNotificationsByRoleArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.notificationsByRole = mapped
    }

    /**
     * @param value The security contact's phone number
     */
    @JvmName("dutvfyofibmwfbps")
    public suspend fun phone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phone = mapped
    }

    /**
     * @param value Name of the security contact object
     */
    @JvmName("iwbntiwitoqqehpn")
    public suspend fun securityContactName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityContactName = mapped
    }

    internal fun build(): SecurityContactArgs = SecurityContactArgs(
        alertNotifications = alertNotifications,
        emails = emails,
        notificationsByRole = notificationsByRole,
        phone = phone,
        securityContactName = securityContactName,
    )
}
