@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.kotlin.outputs.RuleResultsPropertiesResponse
import com.pulumi.azurenative.security.kotlin.outputs.RuleResultsPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SqlVulnerabilityAssessmentBaselineRule].
 */
@PulumiTagMarker
public class SqlVulnerabilityAssessmentBaselineRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlVulnerabilityAssessmentBaselineRuleArgs =
        SqlVulnerabilityAssessmentBaselineRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend SqlVulnerabilityAssessmentBaselineRuleArgsBuilder.() -> Unit) {
        val builder = SqlVulnerabilityAssessmentBaselineRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SqlVulnerabilityAssessmentBaselineRule {
        val builtJavaResource =
            com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlVulnerabilityAssessmentBaselineRule(builtJavaResource)
    }
}

/**
 * Rule results.
 * Azure REST API version: 2023-02-01-preview. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * ## Example Usage
 * ### Create a baseline
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVulnerabilityAssessmentBaselineRule = new AzureNative.Security.SqlVulnerabilityAssessmentBaselineRule("sqlVulnerabilityAssessmentBaselineRule", new()
 *     {
 *         LatestScan = false,
 *         ResourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master",
 *         Results = new[]
 *         {
 *             new[]
 *             {
 *                 "userA",
 *                 "SELECT",
 *             },
 *             new[]
 *             {
 *                 "userB",
 *                 "SELECT",
 *             },
 *         },
 *         RuleId = "VA1234",
 *         WorkspaceId = "55555555-6666-7777-8888-999999999999",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSqlVulnerabilityAssessmentBaselineRule(ctx, "sqlVulnerabilityAssessmentBaselineRule", &security.SqlVulnerabilityAssessmentBaselineRuleArgs{
 * 			LatestScan: pulumi.Bool(false),
 * 			ResourceId: pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master"),
 * 			Results: pulumi.StringArrayArray{
 * 				pulumi.StringArray{
 * 					pulumi.String("userA"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("userB"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 			},
 * 			RuleId:      pulumi.String("VA1234"),
 * 			WorkspaceId: pulumi.String("55555555-6666-7777-8888-999999999999"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRule;
 * import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVulnerabilityAssessmentBaselineRule = new SqlVulnerabilityAssessmentBaselineRule("sqlVulnerabilityAssessmentBaselineRule", SqlVulnerabilityAssessmentBaselineRuleArgs.builder()
 *             .latestScan(false)
 *             .resourceId("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master")
 *             .results(
 *                     "userA",
 *                     "SELECT",
 *                     "userB",
 *                     "SELECT")
 *             .ruleId("VA1234")
 *             .workspaceId("55555555-6666-7777-8888-999999999999")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a baseline using the latest scan results
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVulnerabilityAssessmentBaselineRule = new AzureNative.Security.SqlVulnerabilityAssessmentBaselineRule("sqlVulnerabilityAssessmentBaselineRule", new()
 *     {
 *         LatestScan = true,
 *         ResourceId = "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master",
 *         Results = new[] {},
 *         RuleId = "VA1234",
 *         WorkspaceId = "55555555-6666-7777-8888-999999999999",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewSqlVulnerabilityAssessmentBaselineRule(ctx, "sqlVulnerabilityAssessmentBaselineRule", &security.SqlVulnerabilityAssessmentBaselineRuleArgs{
 * 			LatestScan:  pulumi.Bool(true),
 * 			ResourceId:  pulumi.String("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master"),
 * 			Results:     pulumi.StringArrayArray{},
 * 			RuleId:      pulumi.String("VA1234"),
 * 			WorkspaceId: pulumi.String("55555555-6666-7777-8888-999999999999"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRule;
 * import com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVulnerabilityAssessmentBaselineRule = new SqlVulnerabilityAssessmentBaselineRule("sqlVulnerabilityAssessmentBaselineRule", SqlVulnerabilityAssessmentBaselineRuleArgs.builder()
 *             .latestScan(true)
 *             .resourceId("subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master")
 *             .results()
 *             .ruleId("VA1234")
 *             .workspaceId("55555555-6666-7777-8888-999999999999")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:SqlVulnerabilityAssessmentBaselineRule VA1234 /{resourceId}/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/{ruleId}
 * ```
 */
public class SqlVulnerabilityAssessmentBaselineRule internal constructor(
    override val javaResource: com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRule,
) : KotlinCustomResource(javaResource, SqlVulnerabilityAssessmentBaselineRuleMapper) {
    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Rule results properties.
     */
    public val properties: Output<RuleResultsPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlVulnerabilityAssessmentBaselineRuleMapper :
    ResourceMapper<SqlVulnerabilityAssessmentBaselineRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRule::class == javaResource::class

    override fun map(javaResource: Resource): SqlVulnerabilityAssessmentBaselineRule =
        SqlVulnerabilityAssessmentBaselineRule(
            javaResource as
                com.pulumi.azurenative.security.SqlVulnerabilityAssessmentBaselineRule,
        )
}

/**
 * @see [SqlVulnerabilityAssessmentBaselineRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlVulnerabilityAssessmentBaselineRule].
 */
public suspend fun sqlVulnerabilityAssessmentBaselineRule(
    name: String,
    block: suspend SqlVulnerabilityAssessmentBaselineRuleResourceBuilder.() -> Unit,
):
    SqlVulnerabilityAssessmentBaselineRule {
    val builder = SqlVulnerabilityAssessmentBaselineRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlVulnerabilityAssessmentBaselineRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlVulnerabilityAssessmentBaselineRule(name: String):
    SqlVulnerabilityAssessmentBaselineRule {
    val builder = SqlVulnerabilityAssessmentBaselineRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
