@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WorkspaceSetting].
 */
@PulumiTagMarker
public class WorkspaceSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkspaceSettingArgs = WorkspaceSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkspaceSettingArgsBuilder.() -> Unit) {
        val builder = WorkspaceSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): WorkspaceSetting {
        val builtJavaResource =
            com.pulumi.azurenative.security.WorkspaceSetting(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WorkspaceSetting(builtJavaResource)
    }
}

/**
 * Configures where to store the OMS agent data for workspaces under a scope
 * Azure REST API version: 2017-08-01-preview. Prior API version in Azure Native 1.x: 2017-08-01-preview.
 * ## Example Usage
 * ### Create a workspace setting data for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceSetting = new AzureNative.Security.WorkspaceSetting("workspaceSetting", new()
 *     {
 *         Scope = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         WorkspaceId = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace",
 *         WorkspaceSettingName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewWorkspaceSetting(ctx, "workspaceSetting", &security.WorkspaceSettingArgs{
 * 			Scope:                pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 			WorkspaceId:          pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace"),
 * 			WorkspaceSettingName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.WorkspaceSetting;
 * import com.pulumi.azurenative.security.WorkspaceSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceSetting = new WorkspaceSetting("workspaceSetting", WorkspaceSettingArgs.builder()
 *             .scope("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .workspaceId("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace")
 *             .workspaceSettingName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:WorkspaceSetting default /subscriptions/{subscriptionId}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}
 * ```
 */
public class WorkspaceSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.security.WorkspaceSetting,
) : KotlinCustomResource(javaResource, WorkspaceSettingMapper) {
    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting with more specific scope
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The full Azure ID of the workspace to save the data in
     */
    public val workspaceId: Output<String>
        get() = javaResource.workspaceId().applyValue({ args0 -> args0 })
}

public object WorkspaceSettingMapper : ResourceMapper<WorkspaceSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.security.WorkspaceSetting::class == javaResource::class

    override fun map(javaResource: Resource): WorkspaceSetting = WorkspaceSetting(
        javaResource as
            com.pulumi.azurenative.security.WorkspaceSetting,
    )
}

/**
 * @see [WorkspaceSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WorkspaceSetting].
 */
public suspend fun workspaceSetting(
    name: String,
    block: suspend WorkspaceSettingResourceBuilder.() -> Unit,
): WorkspaceSetting {
    val builder = WorkspaceSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WorkspaceSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workspaceSetting(name: String): WorkspaceSetting {
    val builder = WorkspaceSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
