@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin

import com.pulumi.azurenative.security.WorkspaceSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Configures where to store the OMS agent data for workspaces under a scope
 * Azure REST API version: 2017-08-01-preview. Prior API version in Azure Native 1.x: 2017-08-01-preview.
 * ## Example Usage
 * ### Create a workspace setting data for subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workspaceSetting = new AzureNative.Security.WorkspaceSetting("workspaceSetting", new()
 *     {
 *         Scope = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23",
 *         WorkspaceId = "/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace",
 *         WorkspaceSettingName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/security/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := security.NewWorkspaceSetting(ctx, "workspaceSetting", &security.WorkspaceSettingArgs{
 * 			Scope:                pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23"),
 * 			WorkspaceId:          pulumi.String("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace"),
 * 			WorkspaceSettingName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.security.WorkspaceSetting;
 * import com.pulumi.azurenative.security.WorkspaceSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workspaceSetting = new WorkspaceSetting("workspaceSetting", WorkspaceSettingArgs.builder()
 *             .scope("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23")
 *             .workspaceId("/subscriptions/20ff7fc3-e762-44dd-bd96-b71116dcdc23/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace")
 *             .workspaceSettingName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:security:WorkspaceSetting default /subscriptions/{subscriptionId}/providers/Microsoft.Security/workspaceSettings/{workspaceSettingName}
 * ```
 * @property scope All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting with more specific scope
 * @property workspaceId The full Azure ID of the workspace to save the data in
 * @property workspaceSettingName Name of the security setting
 */
public data class WorkspaceSettingArgs(
    public val scope: Output<String>? = null,
    public val workspaceId: Output<String>? = null,
    public val workspaceSettingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.WorkspaceSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.WorkspaceSettingArgs =
        com.pulumi.azurenative.security.WorkspaceSettingArgs.builder()
            .scope(scope?.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 }))
            .workspaceSettingName(workspaceSettingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceSettingArgs].
 */
@PulumiTagMarker
public class WorkspaceSettingArgsBuilder internal constructor() {
    private var scope: Output<String>? = null

    private var workspaceId: Output<String>? = null

    private var workspaceSettingName: Output<String>? = null

    /**
     * @param value All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting with more specific scope
     */
    @JvmName("jwcnltrxubghgnqx")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The full Azure ID of the workspace to save the data in
     */
    @JvmName("xggibhdvgkopcolj")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value Name of the security setting
     */
    @JvmName("jhynhmfblbdvovgo")
    public suspend fun workspaceSettingName(`value`: Output<String>) {
        this.workspaceSettingName = value
    }

    /**
     * @param value All the VMs in this scope will send their security data to the mentioned workspace unless overridden by a setting with more specific scope
     */
    @JvmName("byhjqhootkvpijfo")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param value The full Azure ID of the workspace to save the data in
     */
    @JvmName("jfwntistkmqqadgv")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    /**
     * @param value Name of the security setting
     */
    @JvmName("oviuosugesmnenwm")
    public suspend fun workspaceSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSettingName = mapped
    }

    internal fun build(): WorkspaceSettingArgs = WorkspaceSettingArgs(
        scope = scope,
        workspaceId = workspaceId,
        workspaceSettingName = workspaceSettingName,
    )
}
