@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The provisioning state of the resource.
 * Pending - Provisioning pending.
 * Failed - Provisioning failed.
 * Succeeded - Successful provisioning.
 * Canceled - Provisioning canceled.
 * PendingDeletion - Deletion pending.
 * DeletionSuccess - Deletion successful.
 * DeletionFailure - Deletion failure.
 */
public enum class DevOpsProvisioningState(
    public val javaValue: com.pulumi.azurenative.security.enums.DevOpsProvisioningState,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.DevOpsProvisioningState> {
    Succeeded(com.pulumi.azurenative.security.enums.DevOpsProvisioningState.Succeeded),
    Failed(com.pulumi.azurenative.security.enums.DevOpsProvisioningState.Failed),
    Canceled(com.pulumi.azurenative.security.enums.DevOpsProvisioningState.Canceled),
    Pending(com.pulumi.azurenative.security.enums.DevOpsProvisioningState.Pending),
    PendingDeletion(com.pulumi.azurenative.security.enums.DevOpsProvisioningState.PendingDeletion),
    DeletionSuccess(com.pulumi.azurenative.security.enums.DevOpsProvisioningState.DeletionSuccess),
    DeletionFailure(com.pulumi.azurenative.security.enums.DevOpsProvisioningState.DeletionFailure),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.DevOpsProvisioningState = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.DevOpsProvisioningState):
            DevOpsProvisioningState =
            DevOpsProvisioningState.values().first { it.javaValue == javaType }
    }
}
