@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The data type of the compared operands (string, integer, floating point number or a boolean [true/false]]
 */
public enum class PropertyType(
    public val javaValue: com.pulumi.azurenative.security.enums.PropertyType,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.PropertyType> {
    String(com.pulumi.azurenative.security.enums.PropertyType.String),
    Integer(com.pulumi.azurenative.security.enums.PropertyType.Integer),
    Number(com.pulumi.azurenative.security.enums.PropertyType.Number),
    Boolean(com.pulumi.azurenative.security.enums.PropertyType.Boolean),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.PropertyType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.PropertyType): PropertyType =
            PropertyType.values().first { it.javaValue == javaType }
    }
}
