@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * A possible role to configure sending security notification alerts to
 */
public enum class Roles(
    public val javaValue: com.pulumi.azurenative.security.enums.Roles,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.Roles> {
    /**
     * If enabled, send notification on new alerts to the account admins
     */
    AccountAdmin(com.pulumi.azurenative.security.enums.Roles.AccountAdmin),

    /**
     * If enabled, send notification on new alerts to the service admins
     */
    ServiceAdmin(com.pulumi.azurenative.security.enums.Roles.ServiceAdmin),

    /**
     * If enabled, send notification on new alerts to the subscription owners
     */
    Owner(com.pulumi.azurenative.security.enums.Roles.Owner),

    /**
     * If enabled, send notification on new alerts to the subscription contributors
     */
    Contributor(com.pulumi.azurenative.security.enums.Roles.Contributor),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.Roles = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.Roles): Roles =
            Roles.values().first { it.javaValue == javaType }
    }
}
