@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Defines whether to send email notifications from AMicrosoft Defender for Cloud to persons with specific RBAC roles on the subscription.
 */
public enum class State(
    public val javaValue: com.pulumi.azurenative.security.enums.State,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.State> {
    /**
     * Send notification on new alerts to the subscription's admins
     */
    On(com.pulumi.azurenative.security.enums.State.On),

    /**
     * Don't send notification on new alerts to the subscription's admins
     */
    Off(com.pulumi.azurenative.security.enums.State.Off),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.State = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.State): State =
            State.values().first { it.javaValue == javaType }
    }
}
