@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or 'Qualys'
 */
public enum class Type(
    public val javaValue: com.pulumi.azurenative.security.enums.Type,
) : ConvertibleToJava<com.pulumi.azurenative.security.enums.Type> {
    Qualys(com.pulumi.azurenative.security.enums.Type.Qualys),
    TVM(com.pulumi.azurenative.security.enums.Type.TVM),
    ;

    override fun toJava(): com.pulumi.azurenative.security.enums.Type = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.enums.Type): Type =
            Type.values().first { it.javaValue == javaType }
    }
}
