@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AdditionalWorkspacesPropertiesArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.AdditionalWorkspaceDataType
import com.pulumi.azurenative.security.kotlin.enums.AdditionalWorkspaceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of the additional workspaces.
 * @property dataTypes List of data types sent to workspace
 * @property type Workspace type.
 * @property workspace Workspace resource id
 */
public data class AdditionalWorkspacesPropertiesArgs(
    public val dataTypes: Output<List<Either<String, AdditionalWorkspaceDataType>>>? = null,
    public val type: Output<Either<String, AdditionalWorkspaceType>>? = null,
    public val workspace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AdditionalWorkspacesPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AdditionalWorkspacesPropertiesArgs =
        com.pulumi.azurenative.security.inputs.AdditionalWorkspacesPropertiesArgs.builder()
            .dataTypes(
                dataTypes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workspace(workspace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdditionalWorkspacesPropertiesArgs].
 */
@PulumiTagMarker
public class AdditionalWorkspacesPropertiesArgsBuilder internal constructor() {
    private var dataTypes: Output<List<Either<String, AdditionalWorkspaceDataType>>>? = null

    private var type: Output<Either<String, AdditionalWorkspaceType>>? = null

    private var workspace: Output<String>? = null

    /**
     * @param value List of data types sent to workspace
     */
    @JvmName("sdnfsqguujfxakxm")
    public suspend fun dataTypes(`value`: Output<List<Either<String, AdditionalWorkspaceDataType>>>) {
        this.dataTypes = value
    }

    @JvmName("rexlmnsgxnlfmumx")
    public suspend fun dataTypes(vararg values: Output<Either<String, AdditionalWorkspaceDataType>>) {
        this.dataTypes = Output.all(values.asList())
    }

    /**
     * @param values List of data types sent to workspace
     */
    @JvmName("dpeidoarnppmbpkw")
    public suspend fun dataTypes(values: List<Output<Either<String, AdditionalWorkspaceDataType>>>) {
        this.dataTypes = Output.all(values)
    }

    /**
     * @param value Workspace type.
     */
    @JvmName("olvcpjigakunoifi")
    public suspend fun type(`value`: Output<Either<String, AdditionalWorkspaceType>>) {
        this.type = value
    }

    /**
     * @param value Workspace resource id
     */
    @JvmName("yrcbjcdbjmvknuvy")
    public suspend fun workspace(`value`: Output<String>) {
        this.workspace = value
    }

    /**
     * @param value List of data types sent to workspace
     */
    @JvmName("iajkkxympyuqdvyk")
    public suspend fun dataTypes(`value`: List<Either<String, AdditionalWorkspaceDataType>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param values List of data types sent to workspace
     */
    @JvmName("xlvwrxdmwgvipkkj")
    public suspend fun dataTypes(vararg values: Either<String, AdditionalWorkspaceDataType>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataTypes = mapped
    }

    /**
     * @param value Workspace type.
     */
    @JvmName("xmtluqdsjlxofnni")
    public suspend fun type(`value`: Either<String, AdditionalWorkspaceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Workspace type.
     */
    @JvmName("kuprlcvwhptpnvva")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AdditionalWorkspaceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Workspace type.
     */
    @JvmName("bviayuxtojjbkvyd")
    public fun type(`value`: AdditionalWorkspaceType) {
        val toBeMapped = Either.ofRight<String, AdditionalWorkspaceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Workspace resource id
     */
    @JvmName("sdwabcnpgncxcjdq")
    public suspend fun workspace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspace = mapped
    }

    internal fun build(): AdditionalWorkspacesPropertiesArgs = AdditionalWorkspacesPropertiesArgs(
        dataTypes = dataTypes,
        type = type,
        workspace = workspace,
    )
}
