@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AssignedComponentItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * describe the properties of a security assessment object reference (by key)
 * @property key unique key to a security assessment object
 */
public data class AssignedComponentItemArgs(
    public val key: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AssignedComponentItemArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AssignedComponentItemArgs =
        com.pulumi.azurenative.security.inputs.AssignedComponentItemArgs.builder()
            .key(key?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssignedComponentItemArgs].
 */
@PulumiTagMarker
public class AssignedComponentItemArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    /**
     * @param value unique key to a security assessment object
     */
    @JvmName("cpnrlgjhuhjfymrc")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value unique key to a security assessment object
     */
    @JvmName("bwiooefsqjvysgng")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): AssignedComponentItemArgs = AssignedComponentItemArgs(
        key = key,
    )
}
