@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AutomationActionWorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Log Analytics Workspace to which event data will be exported. Security alerts data will reside in the 'SecurityAlert' table and the assessments data will reside in the 'SecurityRecommendation' table (under the 'Security'/'SecurityCenterFree' solutions). Note that in order to view the data in the workspace, the Security Center Log Analytics free/standard solution needs to be enabled on that workspace. To learn more about Microsoft Defender for Cloud continuous export capabilities, visit https://aka.ms/ASCExportLearnMore
 * @property actionType The type of the action that will be triggered by the Automation
 * Expected value is 'Workspace'.
 * @property workspaceResourceId The fully qualified Log Analytics Workspace Azure Resource ID.
 */
public data class AutomationActionWorkspaceArgs(
    public val actionType: Output<String>,
    public val workspaceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AutomationActionWorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AutomationActionWorkspaceArgs =
        com.pulumi.azurenative.security.inputs.AutomationActionWorkspaceArgs.builder()
            .actionType(actionType.applyValue({ args0 -> args0 }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutomationActionWorkspaceArgs].
 */
@PulumiTagMarker
public class AutomationActionWorkspaceArgsBuilder internal constructor() {
    private var actionType: Output<String>? = null

    private var workspaceResourceId: Output<String>? = null

    /**
     * @param value The type of the action that will be triggered by the Automation
     * Expected value is 'Workspace'.
     */
    @JvmName("fdwtdeoqeenytgci")
    public suspend fun actionType(`value`: Output<String>) {
        this.actionType = value
    }

    /**
     * @param value The fully qualified Log Analytics Workspace Azure Resource ID.
     */
    @JvmName("hmkbkxlmvbdyfosu")
    public suspend fun workspaceResourceId(`value`: Output<String>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value The type of the action that will be triggered by the Automation
     * Expected value is 'Workspace'.
     */
    @JvmName("mhbluxyftjfraaau")
    public suspend fun actionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionType = mapped
    }

    /**
     * @param value The fully qualified Log Analytics Workspace Azure Resource ID.
     */
    @JvmName("aaqtxcwnwlbgfrhv")
    public suspend fun workspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): AutomationActionWorkspaceArgs = AutomationActionWorkspaceArgs(
        actionType = actionType ?: throw PulumiNullFieldException("actionType"),
        workspaceResourceId = workspaceResourceId,
    )
}
