@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.AzureResourceDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the Azure resource that was assessed
 * @property source The platform where the assessed resource resides
 * Expected value is 'Azure'.
 */
public data class AzureResourceDetailsArgs(
    public val source: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.AzureResourceDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.AzureResourceDetailsArgs =
        com.pulumi.azurenative.security.inputs.AzureResourceDetailsArgs.builder()
            .source(source.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureResourceDetailsArgs].
 */
@PulumiTagMarker
public class AzureResourceDetailsArgsBuilder internal constructor() {
    private var source: Output<String>? = null

    /**
     * @param value The platform where the assessed resource resides
     * Expected value is 'Azure'.
     */
    @JvmName("agnscgsfqwbxjlfh")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The platform where the assessed resource resides
     * Expected value is 'Azure'.
     */
    @JvmName("onqugnbmofbxslfa")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): AzureResourceDetailsArgs = AzureResourceDetailsArgs(
        source = source ?: throw PulumiNullFieldException("source"),
    )
}
