@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.CspmMonitorAwsOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The CSPM monitoring for AWS offering
 * @property nativeCloudConnection The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorAws'.
 */
public data class CspmMonitorAwsOfferingArgs(
    public val nativeCloudConnection: Output<CspmMonitorAwsOfferingNativeCloudConnectionArgs>? = null,
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.CspmMonitorAwsOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.CspmMonitorAwsOfferingArgs =
        com.pulumi.azurenative.security.inputs.CspmMonitorAwsOfferingArgs.builder()
            .nativeCloudConnection(
                nativeCloudConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CspmMonitorAwsOfferingArgs].
 */
@PulumiTagMarker
public class CspmMonitorAwsOfferingArgsBuilder internal constructor() {
    private var nativeCloudConnection: Output<CspmMonitorAwsOfferingNativeCloudConnectionArgs>? = null

    private var offeringType: Output<String>? = null

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("lfpkwpibmquskpqi")
    public suspend
    fun nativeCloudConnection(`value`: Output<CspmMonitorAwsOfferingNativeCloudConnectionArgs>) {
        this.nativeCloudConnection = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorAws'.
     */
    @JvmName("xsqlyvehkvnceshf")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("yrkgnciyrpihcfse")
    public suspend
    fun nativeCloudConnection(`value`: CspmMonitorAwsOfferingNativeCloudConnectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nativeCloudConnection = mapped
    }

    /**
     * @param argument The native cloud connection configuration
     */
    @JvmName("brroabscfrjalutm")
    public suspend
    fun nativeCloudConnection(argument: suspend CspmMonitorAwsOfferingNativeCloudConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = CspmMonitorAwsOfferingNativeCloudConnectionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nativeCloudConnection = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorAws'.
     */
    @JvmName("yqquscdvcvuvijka")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): CspmMonitorAwsOfferingArgs = CspmMonitorAwsOfferingArgs(
        nativeCloudConnection = nativeCloudConnection,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
