@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.CspmMonitorGcpOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The CSPM monitoring for GCP offering
 * @property nativeCloudConnection The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'CspmMonitorGcp'.
 */
public data class CspmMonitorGcpOfferingArgs(
    public val nativeCloudConnection: Output<CspmMonitorGcpOfferingNativeCloudConnectionArgs>? = null,
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.CspmMonitorGcpOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.CspmMonitorGcpOfferingArgs =
        com.pulumi.azurenative.security.inputs.CspmMonitorGcpOfferingArgs.builder()
            .nativeCloudConnection(
                nativeCloudConnection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CspmMonitorGcpOfferingArgs].
 */
@PulumiTagMarker
public class CspmMonitorGcpOfferingArgsBuilder internal constructor() {
    private var nativeCloudConnection: Output<CspmMonitorGcpOfferingNativeCloudConnectionArgs>? = null

    private var offeringType: Output<String>? = null

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("htuulkppntceyrtv")
    public suspend
    fun nativeCloudConnection(`value`: Output<CspmMonitorGcpOfferingNativeCloudConnectionArgs>) {
        this.nativeCloudConnection = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorGcp'.
     */
    @JvmName("fxtmkssbnhrivcdr")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("nufccsrwmvmrbklf")
    public suspend
    fun nativeCloudConnection(`value`: CspmMonitorGcpOfferingNativeCloudConnectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nativeCloudConnection = mapped
    }

    /**
     * @param argument The native cloud connection configuration
     */
    @JvmName("gpgstbkkotovgama")
    public suspend
    fun nativeCloudConnection(argument: suspend CspmMonitorGcpOfferingNativeCloudConnectionArgsBuilder.() -> Unit) {
        val toBeMapped = CspmMonitorGcpOfferingNativeCloudConnectionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nativeCloudConnection = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'CspmMonitorGcp'.
     */
    @JvmName("juugnbggcjqifgbd")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): CspmMonitorGcpOfferingArgs = CspmMonitorGcpOfferingArgs(
        nativeCloudConnection = nativeCloudConnection,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
