@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The ARC autoprovisioning configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature
 * @property configuration Configuration for servers Arc auto provisioning
 * @property enabled Is arc auto provisioning enabled
 */
public data class DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs(
    public val cloudRoleArn: Output<String>? = null,
    public val configuration: Output<DefenderFoDatabasesAwsOfferingConfigurationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs =
        com.pulumi.azurenative.security.inputs.DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 }))
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs].
 */
@PulumiTagMarker
public class DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    private var configuration: Output<DefenderFoDatabasesAwsOfferingConfigurationArgs>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("rygigfejgndpptkn")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value Configuration for servers Arc auto provisioning
     */
    @JvmName("xvhhhiknjlfeajud")
    public suspend
    fun configuration(`value`: Output<DefenderFoDatabasesAwsOfferingConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is arc auto provisioning enabled
     */
    @JvmName("rebbftdangtylssw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature
     */
    @JvmName("whrljrxhtwkkklyj")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    /**
     * @param value Configuration for servers Arc auto provisioning
     */
    @JvmName("yipvnjtwsgjjeikt")
    public suspend fun configuration(`value`: DefenderFoDatabasesAwsOfferingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration for servers Arc auto provisioning
     */
    @JvmName("hmgwgvlmwbafdklh")
    public suspend
    fun configuration(argument: suspend DefenderFoDatabasesAwsOfferingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderFoDatabasesAwsOfferingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is arc auto provisioning enabled
     */
    @JvmName("kanetqroboowblih")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs =
        DefenderFoDatabasesAwsOfferingArcAutoProvisioningArgs(
            cloudRoleArn = cloudRoleArn,
            configuration = configuration,
            enabled = enabled,
        )
}
