@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKubernetesServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The kubernetes service connection configuration
 * @property cloudRoleArn The cloud role ARN in AWS for this feature used for provisioning resources
 */
public data class DefenderForContainersAwsOfferingKubernetesServiceArgs(
    public val cloudRoleArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKubernetesServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKubernetesServiceArgs =
        com.pulumi.azurenative.security.inputs.DefenderForContainersAwsOfferingKubernetesServiceArgs.builder()
            .cloudRoleArn(cloudRoleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForContainersAwsOfferingKubernetesServiceArgs].
 */
@PulumiTagMarker
public class DefenderForContainersAwsOfferingKubernetesServiceArgsBuilder internal constructor() {
    private var cloudRoleArn: Output<String>? = null

    /**
     * @param value The cloud role ARN in AWS for this feature used for provisioning resources
     */
    @JvmName("fdxrscatrjyvfndc")
    public suspend fun cloudRoleArn(`value`: Output<String>) {
        this.cloudRoleArn = value
    }

    /**
     * @param value The cloud role ARN in AWS for this feature used for provisioning resources
     */
    @JvmName("xwbxhkmlmacmlixy")
    public suspend fun cloudRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudRoleArn = mapped
    }

    internal fun build(): DefenderForContainersAwsOfferingKubernetesServiceArgs =
        DefenderForContainersAwsOfferingKubernetesServiceArgs(
            cloudRoleArn = cloudRoleArn,
        )
}
