@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The ARC autoprovisioning configuration
 * @property configuration Configuration for servers Arc auto provisioning
 * @property enabled Is arc auto provisioning enabled
 */
public data class DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs(
    public val configuration: Output<DefenderForDatabasesGcpOfferingConfigurationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs =
        com.pulumi.azurenative.security.inputs.DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs].
 */
@PulumiTagMarker
public class DefenderForDatabasesGcpOfferingArcAutoProvisioningArgsBuilder internal constructor() {
    private var configuration: Output<DefenderForDatabasesGcpOfferingConfigurationArgs>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Configuration for servers Arc auto provisioning
     */
    @JvmName("fdtmkitecyvrqlfk")
    public suspend
    fun configuration(`value`: Output<DefenderForDatabasesGcpOfferingConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is arc auto provisioning enabled
     */
    @JvmName("djnyseirwdapqfoj")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Configuration for servers Arc auto provisioning
     */
    @JvmName("qddgolvkbqbberpy")
    public suspend fun configuration(`value`: DefenderForDatabasesGcpOfferingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration for servers Arc auto provisioning
     */
    @JvmName("eqyaoyxwqpfgpirk")
    public suspend
    fun configuration(argument: suspend DefenderForDatabasesGcpOfferingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForDatabasesGcpOfferingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is arc auto provisioning enabled
     */
    @JvmName("tvjenvqnbkbmamfe")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs =
        DefenderForDatabasesGcpOfferingArcAutoProvisioningArgs(
            configuration = configuration,
            enabled = enabled,
        )
}
