@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForDevOpsAzureDevOpsOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Defender for DevOps for Azure DevOps offering
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForDevOpsAzureDevOps'.
 */
public data class DefenderForDevOpsAzureDevOpsOfferingArgs(
    public val offeringType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForDevOpsAzureDevOpsOfferingArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForDevOpsAzureDevOpsOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderForDevOpsAzureDevOpsOfferingArgs.builder()
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForDevOpsAzureDevOpsOfferingArgs].
 */
@PulumiTagMarker
public class DefenderForDevOpsAzureDevOpsOfferingArgsBuilder internal constructor() {
    private var offeringType: Output<String>? = null

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDevOpsAzureDevOps'.
     */
    @JvmName("lttjaiesolbdvjci")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForDevOpsAzureDevOps'.
     */
    @JvmName("ojygugrksrthiayj")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): DefenderForDevOpsAzureDevOpsOfferingArgs =
        DefenderForDevOpsAzureDevOpsOfferingArgs(
            offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
        )
}
