@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Defender for Servers AWS offering
 * @property arcAutoProvisioning The ARC autoprovisioning configuration
 * @property defenderForServers The Defender for servers connection configuration
 * @property mdeAutoProvisioning The Microsoft Defender for Endpoint autoprovisioning configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'DefenderForServersAws'.
 * @property subPlan configuration for the servers offering subPlan
 * @property vaAutoProvisioning The Vulnerability Assessment autoprovisioning configuration
 * @property vmScanners The Microsoft Defender for Server VM scanning configuration
 */
public data class DefenderForServersAwsOfferingArgs(
    public val arcAutoProvisioning: Output<DefenderForServersAwsOfferingArcAutoProvisioningArgs>? =
        null,
    public val defenderForServers: Output<DefenderForServersAwsOfferingDefenderForServersArgs>? =
        null,
    public val mdeAutoProvisioning: Output<DefenderForServersAwsOfferingMdeAutoProvisioningArgs>? =
        null,
    public val offeringType: Output<String>,
    public val subPlan: Output<DefenderForServersAwsOfferingSubPlanArgs>? = null,
    public val vaAutoProvisioning: Output<DefenderForServersAwsOfferingVaAutoProvisioningArgs>? =
        null,
    public val vmScanners: Output<DefenderForServersAwsOfferingVmScannersArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersAwsOfferingArgs.builder()
            .arcAutoProvisioning(
                arcAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defenderForServers(
                defenderForServers?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .mdeAutoProvisioning(
                mdeAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .offeringType(offeringType.applyValue({ args0 -> args0 }))
            .subPlan(subPlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vaAutoProvisioning(
                vaAutoProvisioning?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vmScanners(vmScanners?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DefenderForServersAwsOfferingArgs].
 */
@PulumiTagMarker
public class DefenderForServersAwsOfferingArgsBuilder internal constructor() {
    private var arcAutoProvisioning: Output<DefenderForServersAwsOfferingArcAutoProvisioningArgs>? =
        null

    private var defenderForServers: Output<DefenderForServersAwsOfferingDefenderForServersArgs>? =
        null

    private var mdeAutoProvisioning: Output<DefenderForServersAwsOfferingMdeAutoProvisioningArgs>? =
        null

    private var offeringType: Output<String>? = null

    private var subPlan: Output<DefenderForServersAwsOfferingSubPlanArgs>? = null

    private var vaAutoProvisioning: Output<DefenderForServersAwsOfferingVaAutoProvisioningArgs>? =
        null

    private var vmScanners: Output<DefenderForServersAwsOfferingVmScannersArgs>? = null

    /**
     * @param value The ARC autoprovisioning configuration
     */
    @JvmName("uwgamgkpbhcxqqcr")
    public suspend
    fun arcAutoProvisioning(`value`: Output<DefenderForServersAwsOfferingArcAutoProvisioningArgs>) {
        this.arcAutoProvisioning = value
    }

    /**
     * @param value The Defender for servers connection configuration
     */
    @JvmName("qmuxfbbppmytnomo")
    public suspend
    fun defenderForServers(`value`: Output<DefenderForServersAwsOfferingDefenderForServersArgs>) {
        this.defenderForServers = value
    }

    /**
     * @param value The Microsoft Defender for Endpoint autoprovisioning configuration
     */
    @JvmName("yvyyaftrvcfxexnf")
    public suspend
    fun mdeAutoProvisioning(`value`: Output<DefenderForServersAwsOfferingMdeAutoProvisioningArgs>) {
        this.mdeAutoProvisioning = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForServersAws'.
     */
    @JvmName("nvbisjxdwbdfiqij")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value configuration for the servers offering subPlan
     */
    @JvmName("nxhwtdwotovhdufv")
    public suspend fun subPlan(`value`: Output<DefenderForServersAwsOfferingSubPlanArgs>) {
        this.subPlan = value
    }

    /**
     * @param value The Vulnerability Assessment autoprovisioning configuration
     */
    @JvmName("yesjagyktlbasjeo")
    public suspend
    fun vaAutoProvisioning(`value`: Output<DefenderForServersAwsOfferingVaAutoProvisioningArgs>) {
        this.vaAutoProvisioning = value
    }

    /**
     * @param value The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("ygolyxxpfpdegijl")
    public suspend fun vmScanners(`value`: Output<DefenderForServersAwsOfferingVmScannersArgs>) {
        this.vmScanners = value
    }

    /**
     * @param value The ARC autoprovisioning configuration
     */
    @JvmName("iiuyrowqcyohnwsp")
    public suspend
    fun arcAutoProvisioning(`value`: DefenderForServersAwsOfferingArcAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcAutoProvisioning = mapped
    }

    /**
     * @param argument The ARC autoprovisioning configuration
     */
    @JvmName("clmdqvlkppqgcbaw")
    public suspend
    fun arcAutoProvisioning(argument: suspend DefenderForServersAwsOfferingArcAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersAwsOfferingArcAutoProvisioningArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.arcAutoProvisioning = mapped
    }

    /**
     * @param value The Defender for servers connection configuration
     */
    @JvmName("rybfmtkttdblhbih")
    public suspend
    fun defenderForServers(`value`: DefenderForServersAwsOfferingDefenderForServersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defenderForServers = mapped
    }

    /**
     * @param argument The Defender for servers connection configuration
     */
    @JvmName("exghcwfpsdmlupwe")
    public suspend
    fun defenderForServers(argument: suspend DefenderForServersAwsOfferingDefenderForServersArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersAwsOfferingDefenderForServersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defenderForServers = mapped
    }

    /**
     * @param value The Microsoft Defender for Endpoint autoprovisioning configuration
     */
    @JvmName("geaockinjjgrwsby")
    public suspend
    fun mdeAutoProvisioning(`value`: DefenderForServersAwsOfferingMdeAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mdeAutoProvisioning = mapped
    }

    /**
     * @param argument The Microsoft Defender for Endpoint autoprovisioning configuration
     */
    @JvmName("anyndumhtwgstusl")
    public suspend
    fun mdeAutoProvisioning(argument: suspend DefenderForServersAwsOfferingMdeAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersAwsOfferingMdeAutoProvisioningArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.mdeAutoProvisioning = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'DefenderForServersAws'.
     */
    @JvmName("ewvfikimnxwykkcl")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    /**
     * @param value configuration for the servers offering subPlan
     */
    @JvmName("fcvuslyvrolludxr")
    public suspend fun subPlan(`value`: DefenderForServersAwsOfferingSubPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subPlan = mapped
    }

    /**
     * @param argument configuration for the servers offering subPlan
     */
    @JvmName("yhveuksnxhpwyetq")
    public suspend
    fun subPlan(argument: suspend DefenderForServersAwsOfferingSubPlanArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersAwsOfferingSubPlanArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.subPlan = mapped
    }

    /**
     * @param value The Vulnerability Assessment autoprovisioning configuration
     */
    @JvmName("cecsgmlgmywjppes")
    public suspend
    fun vaAutoProvisioning(`value`: DefenderForServersAwsOfferingVaAutoProvisioningArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaAutoProvisioning = mapped
    }

    /**
     * @param argument The Vulnerability Assessment autoprovisioning configuration
     */
    @JvmName("gnmsdkpvgkuopwsv")
    public suspend
    fun vaAutoProvisioning(argument: suspend DefenderForServersAwsOfferingVaAutoProvisioningArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersAwsOfferingVaAutoProvisioningArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vaAutoProvisioning = mapped
    }

    /**
     * @param value The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("sstblqwpxcowrhil")
    public suspend fun vmScanners(`value`: DefenderForServersAwsOfferingVmScannersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmScanners = mapped
    }

    /**
     * @param argument The Microsoft Defender for Server VM scanning configuration
     */
    @JvmName("xcngxtpdygvofbhc")
    public suspend
    fun vmScanners(argument: suspend DefenderForServersAwsOfferingVmScannersArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersAwsOfferingVmScannersArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vmScanners = mapped
    }

    internal fun build(): DefenderForServersAwsOfferingArgs = DefenderForServersAwsOfferingArgs(
        arcAutoProvisioning = arcAutoProvisioning,
        defenderForServers = defenderForServers,
        mdeAutoProvisioning = mdeAutoProvisioning,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
        subPlan = subPlan,
        vaAutoProvisioning = vaAutoProvisioning,
        vmScanners = vmScanners,
    )
}
