@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingArcAutoProvisioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The ARC autoprovisioning configuration
 * @property configuration Configuration for servers Arc auto provisioning
 * @property enabled Is arc auto provisioning enabled
 */
public data class DefenderForServersGcpOfferingArcAutoProvisioningArgs(
    public val configuration: Output<DefenderForServersGcpOfferingConfigurationArgs>? = null,
    public val enabled: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingArcAutoProvisioningArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingArcAutoProvisioningArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingArcAutoProvisioningArgs.builder()
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersGcpOfferingArcAutoProvisioningArgs].
 */
@PulumiTagMarker
public class DefenderForServersGcpOfferingArcAutoProvisioningArgsBuilder internal constructor() {
    private var configuration: Output<DefenderForServersGcpOfferingConfigurationArgs>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Configuration for servers Arc auto provisioning
     */
    @JvmName("vpppsiahcyoouqtl")
    public suspend
    fun configuration(`value`: Output<DefenderForServersGcpOfferingConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Is arc auto provisioning enabled
     */
    @JvmName("cpsdshunhhmcmryg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Configuration for servers Arc auto provisioning
     */
    @JvmName("xxgjcptsppidxwre")
    public suspend fun configuration(`value`: DefenderForServersGcpOfferingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument Configuration for servers Arc auto provisioning
     */
    @JvmName("sctsfssyaabpbnlh")
    public suspend
    fun configuration(argument: suspend DefenderForServersGcpOfferingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DefenderForServersGcpOfferingConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Is arc auto provisioning enabled
     */
    @JvmName("vgkdgcgwdditayht")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DefenderForServersGcpOfferingArcAutoProvisioningArgs =
        DefenderForServersGcpOfferingArcAutoProvisioningArgs(
            configuration = configuration,
            enabled = enabled,
        )
}
