@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingDefenderForServersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Defender for servers connection configuration
 * @property serviceAccountEmailAddress The service account email address in GCP for this feature
 * @property workloadIdentityProviderId The workload identity provider id in GCP for this feature
 */
public data class DefenderForServersGcpOfferingDefenderForServersArgs(
    public val serviceAccountEmailAddress: Output<String>? = null,
    public val workloadIdentityProviderId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingDefenderForServersArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingDefenderForServersArgs =
        com.pulumi.azurenative.security.inputs.DefenderForServersGcpOfferingDefenderForServersArgs.builder()
            .serviceAccountEmailAddress(serviceAccountEmailAddress?.applyValue({ args0 -> args0 }))
            .workloadIdentityProviderId(workloadIdentityProviderId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefenderForServersGcpOfferingDefenderForServersArgs].
 */
@PulumiTagMarker
public class DefenderForServersGcpOfferingDefenderForServersArgsBuilder internal constructor() {
    private var serviceAccountEmailAddress: Output<String>? = null

    private var workloadIdentityProviderId: Output<String>? = null

    /**
     * @param value The service account email address in GCP for this feature
     */
    @JvmName("fvbtaitibuuvngxe")
    public suspend fun serviceAccountEmailAddress(`value`: Output<String>) {
        this.serviceAccountEmailAddress = value
    }

    /**
     * @param value The workload identity provider id in GCP for this feature
     */
    @JvmName("biwngmdbavbqrjdc")
    public suspend fun workloadIdentityProviderId(`value`: Output<String>) {
        this.workloadIdentityProviderId = value
    }

    /**
     * @param value The service account email address in GCP for this feature
     */
    @JvmName("kupjsrogflyyeksm")
    public suspend fun serviceAccountEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountEmailAddress = mapped
    }

    /**
     * @param value The workload identity provider id in GCP for this feature
     */
    @JvmName("iclcqprsjcycanvo")
    public suspend fun workloadIdentityProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadIdentityProviderId = mapped
    }

    internal fun build(): DefenderForServersGcpOfferingDefenderForServersArgs =
        DefenderForServersGcpOfferingDefenderForServersArgs(
            serviceAccountEmailAddress = serviceAccountEmailAddress,
            workloadIdentityProviderId = workloadIdentityProviderId,
        )
}
