@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GcpCredentialsDetailsPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * GCP cloud account connector based service to service credentials, the credentials are composed of the organization ID and a JSON API key (write only)
 * @property authProviderX509CertUrl Auth provider x509 certificate URL field of the API key (write only)
 * @property authUri Auth URI field of the API key (write only)
 * @property authenticationType Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
 * Expected value is 'gcpCredentials'.
 * @property clientEmail Client email field of the API key (write only)
 * @property clientId Client ID field of the API key (write only)
 * @property clientX509CertUrl Client x509 certificate URL field of the API key (write only)
 * @property organizationId The organization ID of the GCP cloud account
 * @property privateKey Private key field of the API key (write only)
 * @property privateKeyId Private key ID field of the API key (write only)
 * @property projectId Project ID field of the API key (write only)
 * @property tokenUri Token URI field of the API key (write only)
 * @property type Type field of the API key (write only)
 */
public data class GcpCredentialsDetailsPropertiesArgs(
    public val authProviderX509CertUrl: Output<String>,
    public val authUri: Output<String>,
    public val authenticationType: Output<String>,
    public val clientEmail: Output<String>,
    public val clientId: Output<String>,
    public val clientX509CertUrl: Output<String>,
    public val organizationId: Output<String>,
    public val privateKey: Output<String>,
    public val privateKeyId: Output<String>,
    public val projectId: Output<String>,
    public val tokenUri: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GcpCredentialsDetailsPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GcpCredentialsDetailsPropertiesArgs =
        com.pulumi.azurenative.security.inputs.GcpCredentialsDetailsPropertiesArgs.builder()
            .authProviderX509CertUrl(authProviderX509CertUrl.applyValue({ args0 -> args0 }))
            .authUri(authUri.applyValue({ args0 -> args0 }))
            .authenticationType(authenticationType.applyValue({ args0 -> args0 }))
            .clientEmail(clientEmail.applyValue({ args0 -> args0 }))
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .clientX509CertUrl(clientX509CertUrl.applyValue({ args0 -> args0 }))
            .organizationId(organizationId.applyValue({ args0 -> args0 }))
            .privateKey(privateKey.applyValue({ args0 -> args0 }))
            .privateKeyId(privateKeyId.applyValue({ args0 -> args0 }))
            .projectId(projectId.applyValue({ args0 -> args0 }))
            .tokenUri(tokenUri.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GcpCredentialsDetailsPropertiesArgs].
 */
@PulumiTagMarker
public class GcpCredentialsDetailsPropertiesArgsBuilder internal constructor() {
    private var authProviderX509CertUrl: Output<String>? = null

    private var authUri: Output<String>? = null

    private var authenticationType: Output<String>? = null

    private var clientEmail: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientX509CertUrl: Output<String>? = null

    private var organizationId: Output<String>? = null

    private var privateKey: Output<String>? = null

    private var privateKeyId: Output<String>? = null

    private var projectId: Output<String>? = null

    private var tokenUri: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Auth provider x509 certificate URL field of the API key (write only)
     */
    @JvmName("hooshaahjffafxtp")
    public suspend fun authProviderX509CertUrl(`value`: Output<String>) {
        this.authProviderX509CertUrl = value
    }

    /**
     * @param value Auth URI field of the API key (write only)
     */
    @JvmName("dbrmwcrsoyfdyjyc")
    public suspend fun authUri(`value`: Output<String>) {
        this.authUri = value
    }

    /**
     * @param value Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
     * Expected value is 'gcpCredentials'.
     */
    @JvmName("jynqndlciordmsxu")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Client email field of the API key (write only)
     */
    @JvmName("bnildkdyiatttpew")
    public suspend fun clientEmail(`value`: Output<String>) {
        this.clientEmail = value
    }

    /**
     * @param value Client ID field of the API key (write only)
     */
    @JvmName("yrcchkesuxapruso")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value Client x509 certificate URL field of the API key (write only)
     */
    @JvmName("rtleuobqpbxlqpvd")
    public suspend fun clientX509CertUrl(`value`: Output<String>) {
        this.clientX509CertUrl = value
    }

    /**
     * @param value The organization ID of the GCP cloud account
     */
    @JvmName("yopptfgecrsalcjy")
    public suspend fun organizationId(`value`: Output<String>) {
        this.organizationId = value
    }

    /**
     * @param value Private key field of the API key (write only)
     */
    @JvmName("ytyfxwqcaqhxlvxx")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value Private key ID field of the API key (write only)
     */
    @JvmName("xjicbwyldmpmivqr")
    public suspend fun privateKeyId(`value`: Output<String>) {
        this.privateKeyId = value
    }

    /**
     * @param value Project ID field of the API key (write only)
     */
    @JvmName("jefrlueakeeaqpln")
    public suspend fun projectId(`value`: Output<String>) {
        this.projectId = value
    }

    /**
     * @param value Token URI field of the API key (write only)
     */
    @JvmName("jwgekvkhwjrxvgop")
    public suspend fun tokenUri(`value`: Output<String>) {
        this.tokenUri = value
    }

    /**
     * @param value Type field of the API key (write only)
     */
    @JvmName("umrvttcamgxddmsk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Auth provider x509 certificate URL field of the API key (write only)
     */
    @JvmName("nskjmrxdyfsqjebe")
    public suspend fun authProviderX509CertUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authProviderX509CertUrl = mapped
    }

    /**
     * @param value Auth URI field of the API key (write only)
     */
    @JvmName("ermlbfwakaeblddh")
    public suspend fun authUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authUri = mapped
    }

    /**
     * @param value Connect to your cloud account, for AWS use either account credentials or role-based authentication. For GCP use account organization credentials.
     * Expected value is 'gcpCredentials'.
     */
    @JvmName("xicfknritfhtjyrk")
    public suspend fun authenticationType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Client email field of the API key (write only)
     */
    @JvmName("bjebaohpabkxbhyr")
    public suspend fun clientEmail(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientEmail = mapped
    }

    /**
     * @param value Client ID field of the API key (write only)
     */
    @JvmName("dwdwaguroqlrrobd")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value Client x509 certificate URL field of the API key (write only)
     */
    @JvmName("tqwohtbfcdgrvbyv")
    public suspend fun clientX509CertUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientX509CertUrl = mapped
    }

    /**
     * @param value The organization ID of the GCP cloud account
     */
    @JvmName("duurijtsdnuvavnt")
    public suspend fun organizationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationId = mapped
    }

    /**
     * @param value Private key field of the API key (write only)
     */
    @JvmName("mnqwrbdpfpqlvqoe")
    public suspend fun privateKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    /**
     * @param value Private key ID field of the API key (write only)
     */
    @JvmName("piicsjhpiyubksef")
    public suspend fun privateKeyId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateKeyId = mapped
    }

    /**
     * @param value Project ID field of the API key (write only)
     */
    @JvmName("cmyyocxwopjvfgbd")
    public suspend fun projectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectId = mapped
    }

    /**
     * @param value Token URI field of the API key (write only)
     */
    @JvmName("axjxeilswgrxjyji")
    public suspend fun tokenUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tokenUri = mapped
    }

    /**
     * @param value Type field of the API key (write only)
     */
    @JvmName("jvfwftdjrxjvtofl")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GcpCredentialsDetailsPropertiesArgs = GcpCredentialsDetailsPropertiesArgs(
        authProviderX509CertUrl = authProviderX509CertUrl ?: throw
            PulumiNullFieldException("authProviderX509CertUrl"),
        authUri = authUri ?: throw PulumiNullFieldException("authUri"),
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        clientEmail = clientEmail ?: throw PulumiNullFieldException("clientEmail"),
        clientId = clientId ?: throw PulumiNullFieldException("clientId"),
        clientX509CertUrl = clientX509CertUrl ?: throw PulumiNullFieldException("clientX509CertUrl"),
        organizationId = organizationId ?: throw PulumiNullFieldException("organizationId"),
        privateKey = privateKey ?: throw PulumiNullFieldException("privateKey"),
        privateKeyId = privateKeyId ?: throw PulumiNullFieldException("privateKeyId"),
        projectId = projectId ?: throw PulumiNullFieldException("projectId"),
        tokenUri = tokenUri ?: throw PulumiNullFieldException("tokenUri"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
