@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GcpOrganizationalDataOrganizationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The gcpOrganization data for the parent account
 * @property excludedProjectNumbers If the multi cloud account is of membership type organization, list of accounts excluded from offering
 * @property organizationMembershipType The multi cloud account's membership type in the organization
 * Expected value is 'Organization'.
 * @property serviceAccountEmailAddress The service account email address which represents the organization level permissions container.
 * @property workloadIdentityProviderId The GCP workload identity provider id which represents the permissions required to auto provision security connectors
 */
public data class GcpOrganizationalDataOrganizationArgs(
    public val excludedProjectNumbers: Output<List<String>>? = null,
    public val organizationMembershipType: Output<String>,
    public val serviceAccountEmailAddress: Output<String>? = null,
    public val workloadIdentityProviderId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GcpOrganizationalDataOrganizationArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.GcpOrganizationalDataOrganizationArgs =
        com.pulumi.azurenative.security.inputs.GcpOrganizationalDataOrganizationArgs.builder()
            .excludedProjectNumbers(
                excludedProjectNumbers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .organizationMembershipType(organizationMembershipType.applyValue({ args0 -> args0 }))
            .serviceAccountEmailAddress(serviceAccountEmailAddress?.applyValue({ args0 -> args0 }))
            .workloadIdentityProviderId(workloadIdentityProviderId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GcpOrganizationalDataOrganizationArgs].
 */
@PulumiTagMarker
public class GcpOrganizationalDataOrganizationArgsBuilder internal constructor() {
    private var excludedProjectNumbers: Output<List<String>>? = null

    private var organizationMembershipType: Output<String>? = null

    private var serviceAccountEmailAddress: Output<String>? = null

    private var workloadIdentityProviderId: Output<String>? = null

    /**
     * @param value If the multi cloud account is of membership type organization, list of accounts excluded from offering
     */
    @JvmName("aarrwvkdvdrqptst")
    public suspend fun excludedProjectNumbers(`value`: Output<List<String>>) {
        this.excludedProjectNumbers = value
    }

    @JvmName("cmfhuvbluwtxdoci")
    public suspend fun excludedProjectNumbers(vararg values: Output<String>) {
        this.excludedProjectNumbers = Output.all(values.asList())
    }

    /**
     * @param values If the multi cloud account is of membership type organization, list of accounts excluded from offering
     */
    @JvmName("ifkxmpvjyupdfjkq")
    public suspend fun excludedProjectNumbers(values: List<Output<String>>) {
        this.excludedProjectNumbers = Output.all(values)
    }

    /**
     * @param value The multi cloud account's membership type in the organization
     * Expected value is 'Organization'.
     */
    @JvmName("uuhxvfltcwmivpnc")
    public suspend fun organizationMembershipType(`value`: Output<String>) {
        this.organizationMembershipType = value
    }

    /**
     * @param value The service account email address which represents the organization level permissions container.
     */
    @JvmName("qxhrqtlmfurluyhj")
    public suspend fun serviceAccountEmailAddress(`value`: Output<String>) {
        this.serviceAccountEmailAddress = value
    }

    /**
     * @param value The GCP workload identity provider id which represents the permissions required to auto provision security connectors
     */
    @JvmName("yirmkxuooyydjtcj")
    public suspend fun workloadIdentityProviderId(`value`: Output<String>) {
        this.workloadIdentityProviderId = value
    }

    /**
     * @param value If the multi cloud account is of membership type organization, list of accounts excluded from offering
     */
    @JvmName("iscqstmqhwkjnrud")
    public suspend fun excludedProjectNumbers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedProjectNumbers = mapped
    }

    /**
     * @param values If the multi cloud account is of membership type organization, list of accounts excluded from offering
     */
    @JvmName("tyleugcjfwhgitbw")
    public suspend fun excludedProjectNumbers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedProjectNumbers = mapped
    }

    /**
     * @param value The multi cloud account's membership type in the organization
     * Expected value is 'Organization'.
     */
    @JvmName("jghfylrvboxhlqww")
    public suspend fun organizationMembershipType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationMembershipType = mapped
    }

    /**
     * @param value The service account email address which represents the organization level permissions container.
     */
    @JvmName("ktolhmdlhxkqwfsu")
    public suspend fun serviceAccountEmailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountEmailAddress = mapped
    }

    /**
     * @param value The GCP workload identity provider id which represents the permissions required to auto provision security connectors
     */
    @JvmName("hgwuobsavvqmjlss")
    public suspend fun workloadIdentityProviderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workloadIdentityProviderId = mapped
    }

    internal fun build(): GcpOrganizationalDataOrganizationArgs =
        GcpOrganizationalDataOrganizationArgs(
            excludedProjectNumbers = excludedProjectNumbers,
            organizationMembershipType = organizationMembershipType ?: throw
                PulumiNullFieldException("organizationMembershipType"),
            serviceAccountEmailAddress = serviceAccountEmailAddress,
            workloadIdentityProviderId = workloadIdentityProviderId,
        )
}
