@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GcpProjectDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The details about the project represented by the security connector
 * @property projectId The GCP Project id
 * @property projectNumber The unique GCP Project number
 */
public data class GcpProjectDetailsArgs(
    public val projectId: Output<String>? = null,
    public val projectNumber: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GcpProjectDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GcpProjectDetailsArgs =
        com.pulumi.azurenative.security.inputs.GcpProjectDetailsArgs.builder()
            .projectId(projectId?.applyValue({ args0 -> args0 }))
            .projectNumber(projectNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GcpProjectDetailsArgs].
 */
@PulumiTagMarker
public class GcpProjectDetailsArgsBuilder internal constructor() {
    private var projectId: Output<String>? = null

    private var projectNumber: Output<String>? = null

    /**
     * @param value The GCP Project id
     */
    @JvmName("yfpakdmegkjgtvgj")
    public suspend fun projectId(`value`: Output<String>) {
        this.projectId = value
    }

    /**
     * @param value The unique GCP Project number
     */
    @JvmName("wgdumoifudsglurf")
    public suspend fun projectNumber(`value`: Output<String>) {
        this.projectNumber = value
    }

    /**
     * @param value The GCP Project id
     */
    @JvmName("atsqprjyhhifuidh")
    public suspend fun projectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectId = mapped
    }

    /**
     * @param value The unique GCP Project number
     */
    @JvmName("dvbmmewnoadqkekk")
    public suspend fun projectNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectNumber = mapped
    }

    internal fun build(): GcpProjectDetailsArgs = GcpProjectDetailsArgs(
        projectId = projectId,
        projectNumber = projectNumber,
    )
}
