@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetSecurityConnectorApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationId The security Application key - unique key for the standard application
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 */
public data class GetSecurityConnectorApplicationPlainArgs(
    public val applicationId: String,
    public val resourceGroupName: String,
    public val securityConnectorName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetSecurityConnectorApplicationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.GetSecurityConnectorApplicationPlainArgs =
        com.pulumi.azurenative.security.inputs.GetSecurityConnectorApplicationPlainArgs.builder()
            .applicationId(applicationId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityConnectorApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityConnectorApplicationPlainArgsBuilder internal constructor() {
    private var applicationId: String? = null

    private var resourceGroupName: String? = null

    private var securityConnectorName: String? = null

    /**
     * @param value The security Application key - unique key for the standard application
     */
    @JvmName("xoyyvvhyuhccokmk")
    public suspend fun applicationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationId = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("djyyseubiclqyglc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("jddvmsvvugsjsewn")
    public suspend fun securityConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityConnectorName = mapped
    }

    internal fun build(): GetSecurityConnectorApplicationPlainArgs =
        GetSecurityConnectorApplicationPlainArgs(
            applicationId = applicationId ?: throw PulumiNullFieldException("applicationId"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            securityConnectorName = securityConnectorName ?: throw
                PulumiNullFieldException("securityConnectorName"),
        )
}
