@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetSecurityConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 */
public data class GetSecurityConnectorPlainArgs(
    public val resourceGroupName: String,
    public val securityConnectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetSecurityConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetSecurityConnectorPlainArgs =
        com.pulumi.azurenative.security.inputs.GetSecurityConnectorPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityConnectorPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var securityConnectorName: String? = null

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("eldpdhuiurmtlqyt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("daaeghdvwemacmwi")
    public suspend fun securityConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityConnectorName = mapped
    }

    internal fun build(): GetSecurityConnectorPlainArgs = GetSecurityConnectorPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securityConnectorName = securityConnectorName ?: throw
            PulumiNullFieldException("securityConnectorName"),
    )
}
