@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GetStandardPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property standardId The Security Standard key - unique key for the standard type
 */
public data class GetStandardPlainArgs(
    public val resourceGroupName: String,
    public val standardId: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GetStandardPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GetStandardPlainArgs =
        com.pulumi.azurenative.security.inputs.GetStandardPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .standardId(standardId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStandardPlainArgs].
 */
@PulumiTagMarker
public class GetStandardPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var standardId: String? = null

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("ttpgcnwmkogiaaql")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The Security Standard key - unique key for the standard type
     */
    @JvmName("gevlfoxdmaplrgbg")
    public suspend fun standardId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.standardId = mapped
    }

    internal fun build(): GetStandardPlainArgs = GetStandardPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        standardId = standardId ?: throw PulumiNullFieldException("standardId"),
    )
}
