@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GitlabScopeEnvironmentDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The GitLab scope connector's environment data
 * @property environmentType The type of the environment data.
 * Expected value is 'GitlabScope'.
 */
public data class GitlabScopeEnvironmentDataArgs(
    public val environmentType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GitlabScopeEnvironmentDataArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GitlabScopeEnvironmentDataArgs =
        com.pulumi.azurenative.security.inputs.GitlabScopeEnvironmentDataArgs.builder()
            .environmentType(environmentType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitlabScopeEnvironmentDataArgs].
 */
@PulumiTagMarker
public class GitlabScopeEnvironmentDataArgsBuilder internal constructor() {
    private var environmentType: Output<String>? = null

    /**
     * @param value The type of the environment data.
     * Expected value is 'GitlabScope'.
     */
    @JvmName("neeunmkljctjaesg")
    public suspend fun environmentType(`value`: Output<String>) {
        this.environmentType = value
    }

    /**
     * @param value The type of the environment data.
     * Expected value is 'GitlabScope'.
     */
    @JvmName("qbesrbxptmliefqu")
    public suspend fun environmentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentType = mapped
    }

    internal fun build(): GitlabScopeEnvironmentDataArgs = GitlabScopeEnvironmentDataArgs(
        environmentType = environmentType ?: throw PulumiNullFieldException("environmentType"),
    )
}
