@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.GovernanceRuleOwnerSourceArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.GovernanceRuleOwnerSourceType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describe the owner source of governance rule
 * @property type The owner type for the governance rule owner source
 * @property value The source value e.g. tag key like owner name or email address
 */
public data class GovernanceRuleOwnerSourceArgs(
    public val type: Output<Either<String, GovernanceRuleOwnerSourceType>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.GovernanceRuleOwnerSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.GovernanceRuleOwnerSourceArgs =
        com.pulumi.azurenative.security.inputs.GovernanceRuleOwnerSourceArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GovernanceRuleOwnerSourceArgs].
 */
@PulumiTagMarker
public class GovernanceRuleOwnerSourceArgsBuilder internal constructor() {
    private var type: Output<Either<String, GovernanceRuleOwnerSourceType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The owner type for the governance rule owner source
     */
    @JvmName("amvnofhlgtjacgcx")
    public suspend fun type(`value`: Output<Either<String, GovernanceRuleOwnerSourceType>>) {
        this.type = value
    }

    /**
     * @param value The source value e.g. tag key like owner name or email address
     */
    @JvmName("gqulhpgfxlupmkgw")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The owner type for the governance rule owner source
     */
    @JvmName("yanptwmmhswpdpjq")
    public suspend fun type(`value`: Either<String, GovernanceRuleOwnerSourceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The owner type for the governance rule owner source
     */
    @JvmName("psedkdjygwrlnhuv")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GovernanceRuleOwnerSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The owner type for the governance rule owner source
     */
    @JvmName("kmqxawtndaxravrj")
    public fun type(`value`: GovernanceRuleOwnerSourceType) {
        val toBeMapped = Either.ofRight<String, GovernanceRuleOwnerSourceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The source value e.g. tag key like owner name or email address
     */
    @JvmName("ysnckjeproddygjp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GovernanceRuleOwnerSourceArgs = GovernanceRuleOwnerSourceArgs(
        type = type,
        `value` = `value`,
    )
}
