@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.InformationProtectionAwsOfferingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The information protection for AWS offering
 * @property informationProtection The native cloud connection configuration
 * @property offeringType The type of the security offering.
 * Expected value is 'InformationProtectionAws'.
 */
public data class InformationProtectionAwsOfferingArgs(
    public val informationProtection:
    Output<InformationProtectionAwsOfferingInformationProtectionArgs>? = null,
    public val offeringType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.InformationProtectionAwsOfferingArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.InformationProtectionAwsOfferingArgs =
        com.pulumi.azurenative.security.inputs.InformationProtectionAwsOfferingArgs.builder()
            .informationProtection(
                informationProtection?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .offeringType(offeringType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InformationProtectionAwsOfferingArgs].
 */
@PulumiTagMarker
public class InformationProtectionAwsOfferingArgsBuilder internal constructor() {
    private var informationProtection:
        Output<InformationProtectionAwsOfferingInformationProtectionArgs>? = null

    private var offeringType: Output<String>? = null

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("omuafesljbkrvygu")
    public suspend
    fun informationProtection(`value`: Output<InformationProtectionAwsOfferingInformationProtectionArgs>) {
        this.informationProtection = value
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'InformationProtectionAws'.
     */
    @JvmName("mjjjexottprjrrhj")
    public suspend fun offeringType(`value`: Output<String>) {
        this.offeringType = value
    }

    /**
     * @param value The native cloud connection configuration
     */
    @JvmName("ejbuxbmfshbuyfir")
    public suspend
    fun informationProtection(`value`: InformationProtectionAwsOfferingInformationProtectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.informationProtection = mapped
    }

    /**
     * @param argument The native cloud connection configuration
     */
    @JvmName("qfngsixqjwopwkfq")
    public suspend
    fun informationProtection(argument: suspend InformationProtectionAwsOfferingInformationProtectionArgsBuilder.() -> Unit) {
        val toBeMapped =
            InformationProtectionAwsOfferingInformationProtectionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.informationProtection = mapped
    }

    /**
     * @param value The type of the security offering.
     * Expected value is 'InformationProtectionAws'.
     */
    @JvmName("rpafytcokccmntou")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offeringType = mapped
    }

    internal fun build(): InformationProtectionAwsOfferingArgs = InformationProtectionAwsOfferingArgs(
        informationProtection = informationProtection,
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
    )
}
