@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.ListGitLabGroupAvailablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property securityConnectorName The security connector name.
 */
public data class ListGitLabGroupAvailablePlainArgs(
    public val resourceGroupName: String,
    public val securityConnectorName: String,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.ListGitLabGroupAvailablePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.ListGitLabGroupAvailablePlainArgs =
        com.pulumi.azurenative.security.inputs.ListGitLabGroupAvailablePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityConnectorName(securityConnectorName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListGitLabGroupAvailablePlainArgs].
 */
@PulumiTagMarker
public class ListGitLabGroupAvailablePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var securityConnectorName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("akkwwlfaktbspude")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The security connector name.
     */
    @JvmName("xajfkevcxaesfbpn")
    public suspend fun securityConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityConnectorName = mapped
    }

    internal fun build(): ListGitLabGroupAvailablePlainArgs = ListGitLabGroupAvailablePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securityConnectorName = securityConnectorName ?: throw
            PulumiNullFieldException("securityConnectorName"),
    )
}
