@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.OnPremiseResourceDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Details of the On Premise resource that was assessed
 * @property machineName The name of the machine
 * @property source The platform where the assessed resource resides
 * Expected value is 'OnPremise'.
 * @property sourceComputerId The oms agent Id installed on the machine
 * @property vmuuid The unique Id of the machine
 * @property workspaceId Azure resource Id of the workspace the machine is attached to
 */
public data class OnPremiseResourceDetailsArgs(
    public val machineName: Output<String>,
    public val source: Output<String>,
    public val sourceComputerId: Output<String>,
    public val vmuuid: Output<String>,
    public val workspaceId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.OnPremiseResourceDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.OnPremiseResourceDetailsArgs =
        com.pulumi.azurenative.security.inputs.OnPremiseResourceDetailsArgs.builder()
            .machineName(machineName.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0 }))
            .sourceComputerId(sourceComputerId.applyValue({ args0 -> args0 }))
            .vmuuid(vmuuid.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OnPremiseResourceDetailsArgs].
 */
@PulumiTagMarker
public class OnPremiseResourceDetailsArgsBuilder internal constructor() {
    private var machineName: Output<String>? = null

    private var source: Output<String>? = null

    private var sourceComputerId: Output<String>? = null

    private var vmuuid: Output<String>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value The name of the machine
     */
    @JvmName("ksxyifprwcmbugsb")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value The platform where the assessed resource resides
     * Expected value is 'OnPremise'.
     */
    @JvmName("bgawjdbtjabbxxnt")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value The oms agent Id installed on the machine
     */
    @JvmName("shrgyesylydcsiak")
    public suspend fun sourceComputerId(`value`: Output<String>) {
        this.sourceComputerId = value
    }

    /**
     * @param value The unique Id of the machine
     */
    @JvmName("frwmesvjbelssedr")
    public suspend fun vmuuid(`value`: Output<String>) {
        this.vmuuid = value
    }

    /**
     * @param value Azure resource Id of the workspace the machine is attached to
     */
    @JvmName("kphidwvplpspwtnt")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value The name of the machine
     */
    @JvmName("himcsoywwtvmjqgd")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value The platform where the assessed resource resides
     * Expected value is 'OnPremise'.
     */
    @JvmName("xobrcshqgctcmauc")
    public suspend fun source(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The oms agent Id installed on the machine
     */
    @JvmName("quwrjiffhoedqxcd")
    public suspend fun sourceComputerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceComputerId = mapped
    }

    /**
     * @param value The unique Id of the machine
     */
    @JvmName("dtlkhsirndrihwpe")
    public suspend fun vmuuid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmuuid = mapped
    }

    /**
     * @param value Azure resource Id of the workspace the machine is attached to
     */
    @JvmName("kcxhatktifgtsftp")
    public suspend fun workspaceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): OnPremiseResourceDetailsArgs = OnPremiseResourceDetailsArgs(
        machineName = machineName ?: throw PulumiNullFieldException("machineName"),
        source = source ?: throw PulumiNullFieldException("source"),
        sourceComputerId = sourceComputerId ?: throw PulumiNullFieldException("sourceComputerId"),
        vmuuid = vmuuid ?: throw PulumiNullFieldException("vmuuid"),
        workspaceId = workspaceId ?: throw PulumiNullFieldException("workspaceId"),
    )
}
