@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.PublisherInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents the publisher information of a process/rule
 * @property binaryName The "OriginalName" field taken from the file's version resource
 * @property productName The product name taken from the file's version resource
 * @property publisherName The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
 * @property version The binary file version taken from the file's version resource
 */
public data class PublisherInfoArgs(
    public val binaryName: Output<String>? = null,
    public val productName: Output<String>? = null,
    public val publisherName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.PublisherInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.PublisherInfoArgs =
        com.pulumi.azurenative.security.inputs.PublisherInfoArgs.builder()
            .binaryName(binaryName?.applyValue({ args0 -> args0 }))
            .productName(productName?.applyValue({ args0 -> args0 }))
            .publisherName(publisherName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PublisherInfoArgs].
 */
@PulumiTagMarker
public class PublisherInfoArgsBuilder internal constructor() {
    private var binaryName: Output<String>? = null

    private var productName: Output<String>? = null

    private var publisherName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value The "OriginalName" field taken from the file's version resource
     */
    @JvmName("hmjrxhffkikoifog")
    public suspend fun binaryName(`value`: Output<String>) {
        this.binaryName = value
    }

    /**
     * @param value The product name taken from the file's version resource
     */
    @JvmName("mbpawgrkpnahymyb")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
     */
    @JvmName("cmrwufrmpoqakhxu")
    public suspend fun publisherName(`value`: Output<String>) {
        this.publisherName = value
    }

    /**
     * @param value The binary file version taken from the file's version resource
     */
    @JvmName("nabgddqfghhsshfq")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The "OriginalName" field taken from the file's version resource
     */
    @JvmName("otpsumblyurcdyey")
    public suspend fun binaryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.binaryName = mapped
    }

    /**
     * @param value The product name taken from the file's version resource
     */
    @JvmName("drjpwsgcuswesrsj")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    /**
     * @param value The Subject field of the x.509 certificate used to sign the code, using the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country
     */
    @JvmName("rbgklckqqeucqykc")
    public suspend fun publisherName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherName = mapped
    }

    /**
     * @param value The binary file version taken from the file's version resource
     */
    @JvmName("llwlqmgkfyuluqdq")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PublisherInfoArgs = PublisherInfoArgs(
        binaryName = binaryName,
        productName = productName,
        publisherName = publisherName,
        version = version,
    )
}
