@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.RemediationEtaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The ETA (estimated time of arrival) for remediation
 * @property eta ETA for remediation.
 * @property justification Justification for change of Eta.
 */
public data class RemediationEtaArgs(
    public val eta: Output<String>,
    public val justification: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.RemediationEtaArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.RemediationEtaArgs =
        com.pulumi.azurenative.security.inputs.RemediationEtaArgs.builder()
            .eta(eta.applyValue({ args0 -> args0 }))
            .justification(justification.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RemediationEtaArgs].
 */
@PulumiTagMarker
public class RemediationEtaArgsBuilder internal constructor() {
    private var eta: Output<String>? = null

    private var justification: Output<String>? = null

    /**
     * @param value ETA for remediation.
     */
    @JvmName("sqdmohlmlcbusswi")
    public suspend fun eta(`value`: Output<String>) {
        this.eta = value
    }

    /**
     * @param value Justification for change of Eta.
     */
    @JvmName("oshnwxiylfxlaxua")
    public suspend fun justification(`value`: Output<String>) {
        this.justification = value
    }

    /**
     * @param value ETA for remediation.
     */
    @JvmName("fkolaurytluitecb")
    public suspend fun eta(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eta = mapped
    }

    /**
     * @param value Justification for change of Eta.
     */
    @JvmName("wcvdbpcshwbxouyx")
    public suspend fun justification(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.justification = mapped
    }

    internal fun build(): RemediationEtaArgs = RemediationEtaArgs(
        eta = eta ?: throw PulumiNullFieldException("eta"),
        justification = justification ?: throw PulumiNullFieldException("justification"),
    )
}
