@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.SecurityContactPropertiesAlertNotificationsArgs.builder
import com.pulumi.azurenative.security.kotlin.enums.MinimalSeverity
import com.pulumi.azurenative.security.kotlin.enums.State
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines whether to send email notifications about new security alerts
 * @property minimalSeverity Defines the minimal alert severity which will be sent as email notifications
 * @property state Defines if email notifications will be sent about new security alerts
 */
public data class SecurityContactPropertiesAlertNotificationsArgs(
    public val minimalSeverity: Output<Either<String, MinimalSeverity>>? = null,
    public val state: Output<Either<String, State>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.security.inputs.SecurityContactPropertiesAlertNotificationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.security.inputs.SecurityContactPropertiesAlertNotificationsArgs =
        com.pulumi.azurenative.security.inputs.SecurityContactPropertiesAlertNotificationsArgs.builder()
            .minimalSeverity(
                minimalSeverity?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SecurityContactPropertiesAlertNotificationsArgs].
 */
@PulumiTagMarker
public class SecurityContactPropertiesAlertNotificationsArgsBuilder internal constructor() {
    private var minimalSeverity: Output<Either<String, MinimalSeverity>>? = null

    private var state: Output<Either<String, State>>? = null

    /**
     * @param value Defines the minimal alert severity which will be sent as email notifications
     */
    @JvmName("ltvtgiedjywppoqi")
    public suspend fun minimalSeverity(`value`: Output<Either<String, MinimalSeverity>>) {
        this.minimalSeverity = value
    }

    /**
     * @param value Defines if email notifications will be sent about new security alerts
     */
    @JvmName("tyioihbkyxhoweqt")
    public suspend fun state(`value`: Output<Either<String, State>>) {
        this.state = value
    }

    /**
     * @param value Defines the minimal alert severity which will be sent as email notifications
     */
    @JvmName("ftmjaendjyyvadmr")
    public suspend fun minimalSeverity(`value`: Either<String, MinimalSeverity>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimalSeverity = mapped
    }

    /**
     * @param value Defines the minimal alert severity which will be sent as email notifications
     */
    @JvmName("ljaxlncmyidjiwab")
    public fun minimalSeverity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MinimalSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimalSeverity = mapped
    }

    /**
     * @param value Defines the minimal alert severity which will be sent as email notifications
     */
    @JvmName("qopitwhjbyxhvdap")
    public fun minimalSeverity(`value`: MinimalSeverity) {
        val toBeMapped = Either.ofRight<String, MinimalSeverity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimalSeverity = mapped
    }

    /**
     * @param value Defines if email notifications will be sent about new security alerts
     */
    @JvmName("qsvefqvjphbfnffo")
    public suspend fun state(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Defines if email notifications will be sent about new security alerts
     */
    @JvmName("enhyudfhxerndkea")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Defines if email notifications will be sent about new security alerts
     */
    @JvmName("hfalsqgdakkrfegy")
    public fun state(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SecurityContactPropertiesAlertNotificationsArgs =
        SecurityContactPropertiesAlertNotificationsArgs(
            minimalSeverity = minimalSeverity,
            state = state,
        )
}
