@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.SensitiveDataDiscoveryPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of Sensitive Data Discovery.
 * @property isEnabled Indicates whether Sensitive Data Discovery should be enabled.
 */
public data class SensitiveDataDiscoveryPropertiesArgs(
    public val isEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.SensitiveDataDiscoveryPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.SensitiveDataDiscoveryPropertiesArgs =
        com.pulumi.azurenative.security.inputs.SensitiveDataDiscoveryPropertiesArgs.builder()
            .isEnabled(isEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SensitiveDataDiscoveryPropertiesArgs].
 */
@PulumiTagMarker
public class SensitiveDataDiscoveryPropertiesArgsBuilder internal constructor() {
    private var isEnabled: Output<Boolean>? = null

    /**
     * @param value Indicates whether Sensitive Data Discovery should be enabled.
     */
    @JvmName("hfrxwxjxfhyysgpp")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value Indicates whether Sensitive Data Discovery should be enabled.
     */
    @JvmName("vspyekfpkpnaymjr")
    public suspend fun isEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    internal fun build(): SensitiveDataDiscoveryPropertiesArgs = SensitiveDataDiscoveryPropertiesArgs(
        isEnabled = isEnabled,
    )
}
