@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.StandardComponentPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes properties of an component as related to the standard
 * @property key Component Key matching componentMetadata
 */
public data class StandardComponentPropertiesArgs(
    public val key: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.StandardComponentPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.StandardComponentPropertiesArgs =
        com.pulumi.azurenative.security.inputs.StandardComponentPropertiesArgs.builder()
            .key(key?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StandardComponentPropertiesArgs].
 */
@PulumiTagMarker
public class StandardComponentPropertiesArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    /**
     * @param value Component Key matching componentMetadata
     */
    @JvmName("sjxtkiakftvhfbdn")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Component Key matching componentMetadata
     */
    @JvmName("acbbpsjdojsyqynl")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): StandardComponentPropertiesArgs = StandardComponentPropertiesArgs(
        key = key,
    )
}
