@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.ThresholdCustomAlertRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A custom alert rule that checks if a value (depends on the custom alert type) is within the given range.
 * @property isEnabled Status of the custom alert.
 * @property maxThreshold The maximum threshold.
 * @property minThreshold The minimum threshold.
 * @property ruleType The type of the custom alert rule.
 * Expected value is 'ThresholdCustomAlertRule'.
 */
public data class ThresholdCustomAlertRuleArgs(
    public val isEnabled: Output<Boolean>,
    public val maxThreshold: Output<Int>,
    public val minThreshold: Output<Int>,
    public val ruleType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.ThresholdCustomAlertRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.ThresholdCustomAlertRuleArgs =
        com.pulumi.azurenative.security.inputs.ThresholdCustomAlertRuleArgs.builder()
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .maxThreshold(maxThreshold.applyValue({ args0 -> args0 }))
            .minThreshold(minThreshold.applyValue({ args0 -> args0 }))
            .ruleType(ruleType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThresholdCustomAlertRuleArgs].
 */
@PulumiTagMarker
public class ThresholdCustomAlertRuleArgsBuilder internal constructor() {
    private var isEnabled: Output<Boolean>? = null

    private var maxThreshold: Output<Int>? = null

    private var minThreshold: Output<Int>? = null

    private var ruleType: Output<String>? = null

    /**
     * @param value Status of the custom alert.
     */
    @JvmName("rieqqeeqwvvnmcyf")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The maximum threshold.
     */
    @JvmName("htqyuhyjibnhnfwe")
    public suspend fun maxThreshold(`value`: Output<Int>) {
        this.maxThreshold = value
    }

    /**
     * @param value The minimum threshold.
     */
    @JvmName("wiwrmatbmojkqlwc")
    public suspend fun minThreshold(`value`: Output<Int>) {
        this.minThreshold = value
    }

    /**
     * @param value The type of the custom alert rule.
     * Expected value is 'ThresholdCustomAlertRule'.
     */
    @JvmName("mdusmjepeijwqybj")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value Status of the custom alert.
     */
    @JvmName("vchgsfqcbqexrbio")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The maximum threshold.
     */
    @JvmName("fqfslhkuflhymaxv")
    public suspend fun maxThreshold(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxThreshold = mapped
    }

    /**
     * @param value The minimum threshold.
     */
    @JvmName("rbtxtapjwhseonyr")
    public suspend fun minThreshold(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minThreshold = mapped
    }

    /**
     * @param value The type of the custom alert rule.
     * Expected value is 'ThresholdCustomAlertRule'.
     */
    @JvmName("jvmiwjiayywsjmmp")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    internal fun build(): ThresholdCustomAlertRuleArgs = ThresholdCustomAlertRuleArgs(
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        maxThreshold = maxThreshold ?: throw PulumiNullFieldException("maxThreshold"),
        minThreshold = minThreshold ?: throw PulumiNullFieldException("minThreshold"),
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
    )
}
