@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.inputs

import com.pulumi.azurenative.security.inputs.UserRecommendationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a user that is recommended to be allowed for a certain rule
 * @property recommendationAction The recommendation action of the machine or rule
 * @property username Represents a user that is recommended to be allowed for a certain rule
 */
public data class UserRecommendationArgs(
    public val recommendationAction: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.security.inputs.UserRecommendationArgs> {
    override fun toJava(): com.pulumi.azurenative.security.inputs.UserRecommendationArgs =
        com.pulumi.azurenative.security.inputs.UserRecommendationArgs.builder()
            .recommendationAction(recommendationAction?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserRecommendationArgs].
 */
@PulumiTagMarker
public class UserRecommendationArgsBuilder internal constructor() {
    private var recommendationAction: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The recommendation action of the machine or rule
     */
    @JvmName("uophahripyaqqnbx")
    public suspend fun recommendationAction(`value`: Output<String>) {
        this.recommendationAction = value
    }

    /**
     * @param value Represents a user that is recommended to be allowed for a certain rule
     */
    @JvmName("oowjxdyvcdokybyj")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The recommendation action of the machine or rule
     */
    @JvmName("snxrbxtpxtyjjxkn")
    public suspend fun recommendationAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recommendationAction = mapped
    }

    /**
     * @param value Represents a user that is recommended to be allowed for a certain rule
     */
    @JvmName("ciwqiwgcfoisfake")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): UserRecommendationArgs = UserRecommendationArgs(
        recommendationAction = recommendationAction,
        username = username,
    )
}
