@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Links relevant to the assessment
 * @property azurePortalUri Link to assessment in Azure Portal
 */
public data class AssessmentLinksResponse(
    public val azurePortalUri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AssessmentLinksResponse):
            AssessmentLinksResponse = AssessmentLinksResponse(
            azurePortalUri = javaType.azurePortalUri(),
        )
    }
}
