@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The AWS organization data for the master account
 * @property excludedAccountIds If the multi cloud account is of membership type organization, list of accounts excluded from offering
 * @property organizationMembershipType The multi cloud account's membership type in the organization
 * Expected value is 'Organization'.
 * @property stacksetName If the multi cloud account is of membership type organization, this will be the name of the onboarding stackset
 */
public data class AwsOrganizationalDataMasterResponse(
    public val excludedAccountIds: List<String>? = null,
    public val organizationMembershipType: String,
    public val stacksetName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AwsOrganizationalDataMasterResponse):
            AwsOrganizationalDataMasterResponse = AwsOrganizationalDataMasterResponse(
            excludedAccountIds = javaType.excludedAccountIds().map({ args0 -> args0 }),
            organizationMembershipType = javaType.organizationMembershipType(),
            stacksetName = javaType.stacksetName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
