@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The AzureDevOps scope connector's environment data
 * @property environmentType The type of the environment data.
 * Expected value is 'AzureDevOpsScope'.
 */
public data class AzureDevOpsScopeEnvironmentDataResponse(
    public val environmentType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.AzureDevOpsScopeEnvironmentDataResponse):
            AzureDevOpsScopeEnvironmentDataResponse = AzureDevOpsScopeEnvironmentDataResponse(
            environmentType = javaType.environmentType(),
        )
    }
}
