@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * The Vulnerability Assessment autoprovisioning configuration
 * @property configuration configuration for Vulnerability Assessment autoprovisioning
 * @property enabled Is Vulnerability Assessment auto provisioning enabled
 */
public data class DefenderForServersAwsOfferingResponseVaAutoProvisioning(
    public val configuration: DefenderForServersAwsOfferingResponseConfigurationConfiguration? = null,
    public val enabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersAwsOfferingResponseVaAutoProvisioning):
            DefenderForServersAwsOfferingResponseVaAutoProvisioning =
            DefenderForServersAwsOfferingResponseVaAutoProvisioning(
                configuration = javaType.configuration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.security.kotlin.outputs.DefenderForServersAwsOfferingResponseConfigurationConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
