@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Defender for servers connection configuration
 * @property serviceAccountEmailAddress The service account email address in GCP for this feature
 * @property workloadIdentityProviderId The workload identity provider id in GCP for this feature
 */
public data class DefenderForServersGcpOfferingResponseDefenderForServers(
    public val serviceAccountEmailAddress: String? = null,
    public val workloadIdentityProviderId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.DefenderForServersGcpOfferingResponseDefenderForServers):
            DefenderForServersGcpOfferingResponseDefenderForServers =
            DefenderForServersGcpOfferingResponseDefenderForServers(
                serviceAccountEmailAddress = javaType.serviceAccountEmailAddress().map({ args0 ->
                    args0
                }).orElse(null),
                workloadIdentityProviderId = javaType.workloadIdentityProviderId().map({ args0 ->
                    args0
                }).orElse(null),
            )
    }
}
