@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A vulnerability assessments setting on Azure servers in the defined scope.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property kind The kind of the server vulnerability assessments setting
 * Expected value is 'AzureServersSetting'.
 * @property name The name of the resource
 * @property selectedProvider The selected vulnerability assessments provider on Azure servers in the defined scope.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAzureServersSettingResult(
    public val id: String,
    public val kind: String,
    public val name: String,
    public val selectedProvider: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetAzureServersSettingResult):
            GetAzureServersSettingResult = GetAzureServersSettingResult(
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            selectedProvider = javaType.selectedProvider(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
