@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Security Standard on a resource
 * @property category category of the standard provided
 * @property components List of component objects containing component unique keys (such as assessment keys) to apply to standard scope.  Currently only supports assessment keys.
 * @property description description of the standard
 * @property displayName display name of the standard, equivalent to the standardId
 * @property etag Entity tag is used for comparing two or more entities from the same requested resource.
 * @property id Resource Id
 * @property kind Kind of the resource
 * @property location Location where the resource is stored
 * @property name Resource name
 * @property standardType standard type (Custom or BuiltIn only currently)
 * @property supportedClouds List of all standard supported clouds.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags A list of key value pairs that describe the resource.
 * @property type Resource type
 */
public data class GetStandardResult(
    public val category: String? = null,
    public val components: List<StandardComponentPropertiesResponse>? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val kind: String? = null,
    public val location: String? = null,
    public val name: String,
    public val standardType: String,
    public val supportedClouds: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GetStandardResult):
            GetStandardResult = GetStandardResult(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.security.kotlin.outputs.StandardComponentPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            standardType = javaType.standardType(),
            supportedClouds = javaType.supportedClouds().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.security.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
