@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * GitLab Group properties.
 * @property fullyQualifiedFriendlyName Gets or sets the human readable fully-qualified name of the Group object.
 * This contains the entire namespace hierarchy as seen on GitLab UI where namespaces are separated by the '/' character.
 * @property fullyQualifiedName Gets or sets the fully-qualified name of the Group object.
 * This contains the entire namespace hierarchy where namespaces are separated by the '$' character.
 * @property onboardingState Details about resource onboarding status across all connectors.
 * OnboardedByOtherConnector - this resource has already been onboarded to another connector. This is only applicable to top-level resources.
 * Onboarded - this resource has already been onboarded by the specified connector.
 * NotOnboarded - this resource has not been onboarded to any connector.
 * NotApplicable - the onboarding state is not applicable to the current endpoint.
 * @property provisioningState The provisioning state of the resource.
 * Pending - Provisioning pending.
 * Failed - Provisioning failed.
 * Succeeded - Successful provisioning.
 * Canceled - Provisioning canceled.
 * PendingDeletion - Deletion pending.
 * DeletionSuccess - Deletion successful.
 * DeletionFailure - Deletion failure.
 * @property provisioningStatusMessage Gets or sets resource status message.
 * @property provisioningStatusUpdateTimeUtc Gets or sets time when resource was last checked.
 * @property url Gets or sets the url of the GitLab Group.
 */
public data class GitLabGroupPropertiesResponse(
    public val fullyQualifiedFriendlyName: String,
    public val fullyQualifiedName: String,
    public val onboardingState: String? = null,
    public val provisioningState: String? = null,
    public val provisioningStatusMessage: String,
    public val provisioningStatusUpdateTimeUtc: String,
    public val url: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GitLabGroupPropertiesResponse):
            GitLabGroupPropertiesResponse = GitLabGroupPropertiesResponse(
            fullyQualifiedFriendlyName = javaType.fullyQualifiedFriendlyName(),
            fullyQualifiedName = javaType.fullyQualifiedName(),
            onboardingState = javaType.onboardingState().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            provisioningStatusMessage = javaType.provisioningStatusMessage(),
            provisioningStatusUpdateTimeUtc = javaType.provisioningStatusUpdateTimeUtc(),
            url = javaType.url(),
        )
    }
}
