@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The governance rule metadata
 * @property createdBy Governance rule Created by object id (GUID)
 * @property createdOn Governance rule creation date
 * @property updatedBy Governance rule last updated by object id (GUID)
 * @property updatedOn Governance rule last update date
 */
public data class GovernanceRuleMetadataResponse(
    public val createdBy: String,
    public val createdOn: String,
    public val updatedBy: String,
    public val updatedOn: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.GovernanceRuleMetadataResponse):
            GovernanceRuleMetadataResponse = GovernanceRuleMetadataResponse(
            createdBy = javaType.createdBy(),
            createdOn = javaType.createdOn(),
            updatedBy = javaType.updatedBy(),
            updatedOn = javaType.updatedOn(),
        )
    }
}
