@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.security.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The type of IoT Security recommendation.
 * @property name
 * @property recommendationType The type of IoT Security recommendation.
 * @property status Recommendation status. When the recommendation status is disabled recommendations are not generated.
 */
public data class RecommendationConfigurationPropertiesResponse(
    public val name: String,
    public val recommendationType: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.security.outputs.RecommendationConfigurationPropertiesResponse):
            RecommendationConfigurationPropertiesResponse =
            RecommendationConfigurationPropertiesResponse(
                name = javaType.name(),
                recommendationType = javaType.recommendationType(),
                status = javaType.status(),
            )
    }
}
